using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ConsoleApp1
{
    internal class Program
    {
        struct Jarbol
        {
            public int x, y;

            public Jarbol(int x, int y)
            {
                this.x = x;
                this.y = y;
            }
        }

        static void Main(string[] args)
        {
            int N = int.Parse(Console.ReadLine());
            int[] x = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);
            int[] y = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);

            int[] Resenja = new int[N];
           
            Jarbol[] Jarboli = new Jarbol[N];

            for (int i = 0; i < N; i++)
            {
                Jarboli[i] = new Jarbol(x[i], y[i]);
                Resenja[i] = int.MaxValue;
            }

            Array.Sort(Jarboli , (j1 , j2) => j1.x.CompareTo(j2.x));

            // Levo -> Desno

            for (int i = 0; i < N; i++)
            {
                for (int j = i + 1; j < N; j++)
                {
                    if (Jarboli[i].y > Jarboli[j].y) continue;

                    Resenja[i] = Jarboli[j].x - Jarboli[i].x - (Jarboli[j].y - Jarboli[i].y);
                    break;
                }
            }

            for (int i = N - 1; i >= 0; i--)
            {
                for (int j = i - 1; j >= 0; j--)
                {
                    if (Jarboli[i].y > Jarboli[j].y) continue;

                    Resenja[i] = Math.Min(Resenja[i], Jarboli[i].x - Jarboli[j].x - (Jarboli[j].y - Jarboli[i].y));
                    break;
                }
            }

            foreach (int r in Resenja)
            {
                if (r == int.MaxValue) Console.WriteLine(-1);
                else Console.WriteLine(r);
            }
        }
    }
}